package elaprendiz.estructuras.nodos;

import java.awt.Point;

import java.util.Hashtable;
import java.util.Vector;

import elaprendiz.graficos.imagenes.ImageFrame;
import elaprendiz.graficos.imagenes.ObjetoImagen;


public abstract class Nodo extends ObjetoImagen implements Solicitable {

  ///////////////////////////////////
  // Solicitable valor used for compar-
  // isons in data structures

  protected int valor;

  ///////////////////////////////////
  // Links to other and all nodos

  protected Hashtable nodos;


  public Nodo(Point origen, ImageFrame frame, int valor) {
    super(origen, frame, "" + valor);

    this.valor = valor;
    this.nodos = new Hashtable();
  }

  /** Null constructor. When this constructor is called a pure graphics
   *  object is created (only the point concept is implemented). This is
   *  used for graphics operations which require a location but no actual
   *  image or node.
   */
  public Nodo(Point origin) {
    super(origin, null, null);
  }

  public Nodo(Nodo node) {
    super( (ObjetoImagen) node);

    this.valor = valor;
    this.nodos = new Hashtable();
  }


  public int getValue() {
    return valor;
  }

  ///////////////////////////////////////////////////////////////////////////
  // Methods required by Solicitable interface.
  //
  // These methods satisfy orderable requirements for the various algorithms
  // and data structures.
  ///////////////////////////////////////////////////////////////////////////

  public boolean menorQue(Solicitable object) {
    return ( ( (Nodo) object).valor < valor);
  }

  public boolean mayorQue(Solicitable object) {
    return ( ( (Nodo) object).valor > valor);
  }

  public boolean igual(Solicitable object) {
    return ( ( (Nodo) object).valor == valor);
  }

  abstract public Vector cloneStructure();
}
    
